#!/usr/bin/python3
"""Set Mumble Server Default Super User password
Option:
    --pass=     unless provided, will ask interactively
"""

import sys
import getopt

from libinithooks.dialog_wrapper import Dialog
import subprocess

def usage(s=None):
    if s:
        print("Error:", s, file=sys.stderr)
    print("Syntax: %s [options]" % sys.argv[0], file=sys.stderr)
    print(__doc__, file=sys.stderr)
    sys.exit(1)

def main():
    try:
        opts, args = getopt.gnu_getopt(sys.argv[1:], "h",
                                       ['help', 'pass='])
    except getopt.GetoptError as e:
        usage(e)

    password = ""
    for opt, val in opts:
        if opt in ('-h', '--help'):
            usage()
        elif opt == '--pass':
            password = val

    if not password:
        d = Dialog('TurnKey Linux - First boot configuration')
        password = d.get_password(
            "Mumble Server SuperUser Password",
            "Enter SuperUser Password.")
    
    subprocess.run(['murmurd', '-ini', '/etc/mumble-server.ini', '-supw', password])
    subprocess.run(['service', 'mumble-server', 'restart'])

if __name__ == "__main__":
    main()
