/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0b2_r792
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(d){d.jqplot.CanvasOverlay=function(j){var g=j||{};this.options={show:d.jqplot.config.enablePlugins,deferDraw:false};this.objects=[];this.objectNames=[];this.canvas=null;this.markerRenderer=new d.jqplot.MarkerRenderer({style:"line"});this.markerRenderer.init();if(g.objects){var l=g.objects,k;for(var h=0;h<l.length;h++){k=l[h];for(var m in k){switch(m){case"line":this.addLine(k[m]);break;case"horizontalLine":this.addHorizontalLine(k[m]);break;case"dashedHorizontalLine":this.addDashedHorizontalLine(k[m]);break;case"verticalLine":this.addVerticalLine(k[m]);break;case"dashedVerticalLine":this.addDashedVerticalLine(k[m]);break;default:break}}}}d.extend(true,this.options,g)};d.jqplot.CanvasOverlay.postPlotInit=function(j,i,h){var g=h||{};this.plugins.canvasOverlay=new d.jqplot.CanvasOverlay(g.canvasOverlay)};function e(g){this.type="line";this.options={name:null,show:true,lineWidth:2,lineCap:"round",color:"#666666",shadow:true,shadowAngle:45,shadowOffset:1,shadowDepth:3,shadowAlpha:"0.07",xaxis:"xaxis",yaxis:"yaxis",start:[],stop:[]};d.extend(true,this.options,g)}function b(g){this.type="horizontalLine";this.options={name:null,show:true,lineWidth:2,lineCap:"round",color:"#666666",shadow:true,shadowAngle:45,shadowOffset:1,shadowDepth:3,shadowAlpha:"0.07",xaxis:"xaxis",yaxis:"yaxis",y:null,xmin:null,xmax:null,xOffset:"6px",xminOffset:null,xmaxOffset:null};d.extend(true,this.options,g)}function f(g){this.type="dashedHorizontalLine";this.options={name:null,show:true,lineWidth:2,lineCap:"butt",color:"#666666",shadow:true,shadowAngle:45,shadowOffset:1,shadowDepth:3,shadowAlpha:"0.07",xaxis:"xaxis",yaxis:"yaxis",y:null,xmin:null,xmax:null,xOffset:"6px",xminOffset:null,xmaxOffset:null,dashPattern:[8,8]};d.extend(true,this.options,g)}function a(g){this.type="verticalLine";this.options={name:null,show:true,lineWidth:2,lineCap:"round",color:"#666666",shadow:true,shadowAngle:45,shadowOffset:1,shadowDepth:3,shadowAlpha:"0.07",xaxis:"xaxis",yaxis:"yaxis",x:null,ymin:null,ymax:null,yOffset:"6px",yminOffset:null,ymaxOffset:null};d.extend(true,this.options,g)}function c(g){this.type="dashedVerticalLine";this.options={name:null,show:true,lineWidth:2,lineCap:"butt",color:"#666666",shadow:true,shadowAngle:45,shadowOffset:1,shadowDepth:3,shadowAlpha:"0.07",xaxis:"xaxis",yaxis:"yaxis",x:null,ymin:null,ymax:null,yOffset:"6px",yminOffset:null,ymaxOffset:null,dashPattern:[8,8]};d.extend(true,this.options,g)}d.jqplot.CanvasOverlay.prototype.addLine=function(h){var g=new e(h);this.objects.push(g);this.objectNames.push(g.options.name)};d.jqplot.CanvasOverlay.prototype.addHorizontalLine=function(h){var g=new b(h);this.objects.push(g);this.objectNames.push(g.options.name)};d.jqplot.CanvasOverlay.prototype.addDashedHorizontalLine=function(h){var g=new f(h);this.objects.push(g);this.objectNames.push(g.options.name)};d.jqplot.CanvasOverlay.prototype.addVerticalLine=function(h){var g=new a(h);this.objects.push(g);this.objectNames.push(g.options.name)};d.jqplot.CanvasOverlay.prototype.addDashedVerticalLine=function(h){var g=new c(h);this.objects.push(g);this.objectNames.push(g.options.name)};d.jqplot.CanvasOverlay.prototype.removeObject=function(g){if(d.type(g)=="number"){this.objects.splice(g,1);this.objectNames.splice(g,1)}else{var h=d.inArray(g,this.objectNames);if(h!=-1){this.objects.splice(h,1);this.objectNames.splice(h,1)}}};d.jqplot.CanvasOverlay.prototype.getObject=function(g){if(d.type(g)=="number"){return this.objects[g]}else{var h=d.inArray(g,this.objectNames);if(h!=-1){return this.objects[h]}}};d.jqplot.CanvasOverlay.prototype.get=d.jqplot.CanvasOverlay.prototype.getObject;d.jqplot.CanvasOverlay.prototype.clear=function(g){this.canvas._ctx.clearRect(0,0,this.canvas.getWidth(),this.canvas.getHeight())};d.jqplot.CanvasOverlay.prototype.draw=function(G){var u,r=this.objects,B=this.markerRenderer,o,C;if(this.options.show){this.canvas._ctx.clearRect(0,0,this.canvas.getWidth(),this.canvas.getHeight());for(var D=0;D<r.length;D++){u=r[D];var v=d.extend(true,{},u.options);if(u.options.show){B.shadow=u.options.shadow;switch(u.type){case"line":B.style="line";v.closePath=false;o=[G.axes[u.options.xaxis].series_u2p(u.options.start[0]),G.axes[u.options.yaxis].series_u2p(u.options.start[1])];C=[G.axes[u.options.xaxis].series_u2p(u.options.stop[0]),G.axes[u.options.yaxis].series_u2p(u.options.stop[1])];B.draw(o,C,this.canvas._ctx,v);break;case"horizontalLine":if(u.options.y!=null){B.style="line";v.closePath=false;var l=G.axes[u.options.xaxis],O,H,s=G.axes[u.options.yaxis].series_u2p(u.options.y),E=u.options.xminOffset||u.options.xOffset,p=u.options.xmaxOffset||u.options.xOffset;if(u.options.xmin!=null){O=l.series_u2p(u.options.xmin)}else{if(E!=null){if(d.type(E)=="number"){O=l.series_u2p(l.min+E)}else{if(d.type(E)=="string"){O=l.series_u2p(l.min)+parseFloat(E)}}}}if(u.options.xmax!=null){H=l.series_u2p(u.options.xmax)}else{if(p!=null){if(d.type(p)=="number"){H=l.series_u2p(l.max-p)}else{if(d.type(p)=="string"){H=l.series_u2p(l.max)-parseFloat(p)}}}}if(H!=null&&O!=null){B.draw([O,s],[H,s],this.canvas._ctx,v)}}break;case"dashedHorizontalLine":var h=u.options.dashPattern;var A=0;for(var I=0;I<h.length;I++){A+=h[I]}if(u.options.y!=null){B.style="line";v.closePath=false;var l=G.axes[u.options.xaxis],O,H,s=G.axes[u.options.yaxis].series_u2p(u.options.y),E=u.options.xminOffset||u.options.xOffset,p=u.options.xmaxOffset||u.options.xOffset;if(u.options.xmin!=null){O=l.series_u2p(u.options.xmin)}else{if(E!=null){if(d.type(E)=="number"){O=l.series_u2p(l.min+E)}else{if(d.type(E)=="string"){O=l.series_u2p(l.min)+parseFloat(E)}}}}if(u.options.xmax!=null){H=l.series_u2p(u.options.xmax)}else{if(p!=null){if(d.type(p)=="number"){H=l.series_u2p(l.max-p)}else{if(d.type(p)=="string"){H=l.series_u2p(l.max)-parseFloat(p)}}}}if(H!=null&&O!=null){var n=Math.ceil((H-O)/A);var M=O,K;for(var I=0;I<n;I++){for(var F=0;F<h.length;F+=2){K=M+h[F];B.draw([M,s],[K,s],this.canvas._ctx,v);M+=h[F];if(F<h.length-1){M+=h[F+1]}}}}}break;case"verticalLine":if(u.options.x!=null){B.style="line";v.closePath=false;var J=G.axes[u.options.yaxis],g,q,t=G.axes[u.options.xaxis].series_u2p(u.options.x),z=u.options.yminOffset||u.options.yOffset,m=u.options.ymaxOffset||u.options.yOffset;if(u.options.ymin!=null){g=J.series_u2p(u.options.ymin)}else{if(z!=null){if(d.type(z)=="number"){g=J.series_u2p(J.min-z)}else{if(d.type(z)=="string"){g=J.series_u2p(J.min)-parseFloat(z)}}}}if(u.options.ymax!=null){q=J.series_u2p(u.options.ymax)}else{if(m!=null){if(d.type(m)=="number"){q=J.series_u2p(J.max+m)}else{if(d.type(m)=="string"){q=J.series_u2p(J.max)+parseFloat(m)}}}}if(q!=null&&g!=null){B.draw([t,g],[t,q],this.canvas._ctx,v)}}break;case"dashedVerticalLine":var h=u.options.dashPattern;var A=0;for(var I=0;I<h.length;I++){A+=h[I]}if(u.options.x!=null){B.style="line";v.closePath=false;var J=G.axes[u.options.yaxis],g,q,t=G.axes[u.options.xaxis].series_u2p(u.options.x),z=u.options.yminOffset||u.options.yOffset,m=u.options.ymaxOffset||u.options.yOffset;if(u.options.ymin!=null){g=J.series_u2p(u.options.ymin)}else{if(z!=null){if(d.type(z)=="number"){g=J.series_u2p(J.min-z)}else{if(d.type(z)=="string"){g=J.series_u2p(J.min)-parseFloat(z)}}}}if(u.options.ymax!=null){q=J.series_u2p(u.options.ymax)}else{if(m!=null){if(d.type(m)=="number"){q=J.series_u2p(J.max+m)}else{if(d.type(m)=="string"){q=J.series_u2p(J.max)+parseFloat(m)}}}}if(q!=null&&g!=null){var n=Math.ceil((g-q)/A);var w=((n*A)-(g-q))/2;var M=g,K,L,N;for(var I=0;I<n;I++){for(var F=0;F<h.length;F+=2){K=M-h[F];if(K<q){K=q}if(M<q){M=q}B.draw([t,M],[t,K],this.canvas._ctx,v);M-=h[F];if(F<h.length-1){M-=h[F+1]}}}}}break;default:break}}}}};d.jqplot.CanvasOverlay.postPlotDraw=function(){if(this.plugins.canvasOverlay&&this.plugins.canvasOverlay.highlightCanvas){this.plugins.canvasOverlay.highlightCanvas.resetCanvas();this.plugins.canvasOverlay.highlightCanvas=null}this.plugins.canvasOverlay.canvas=new d.jqplot.GenericCanvas();this.eventCanvas._elem.before(this.plugins.canvasOverlay.canvas.createElement(this._gridPadding,"jqplot-overlayCanvas-canvas",this._plotDimensions,this));this.plugins.canvasOverlay.canvas.setContext();if(!this.plugins.canvasOverlay.deferDraw){this.plugins.canvasOverlay.draw(this)}};d.jqplot.postInitHooks.push(d.jqplot.CanvasOverlay.postPlotInit);d.jqplot.postDrawHooks.push(d.jqplot.CanvasOverlay.postPlotDraw)})(jQuery);