#!/bin/bash

#  murmurdautofirewall.sh
#  
#
#  Created by MG on 11/14/16.
#

#Infinite Loop with 300 Second Sleep time (look for murmurd instances and firewall rules)
while :
do

#Create File With List of Murmur Instances
#UDP used to prevent duplicate rules and rules for ice interface etc.
lsof -i UDP | fgrep murmurd | sed 's/.*://g' > ports
#Create File With List of IP Table Rules
#When rules are autocreated they are commented with murmurdautofirewall.
#Comment allows for only murmurdautofirewall rules to be selected as well.
#UDP used in sed in order to ensure no duplicate ports
iptables -L | sed 's/udp.*murmurdautofirewall.*//g' | sed 's/[^0-9]*//g' | sed '/^$/d' > rules


#Iterate through list of ports generated by lsof -i UDP | fgrep murmurd | sed 's/.*://g' > ports
while read port
do
#Check if rule exists for murmurd on each port
#If rule exists end message to system log indicating port to remain open
if grep -q "$port" rules;
then
echo
#logger Firewall port $port will remain open
#If rule does not exist create rule to accept connections on listening port
#Send message to system log that firewall port was opened
else
logger Firewall port $port was opened.
iptables -A INPUT -p tcp --dport $port -m comment --comment "murmurdautofirewall" -j ACCEPT
iptables -A INPUT -p udp --dport $port -m comment --comment "murmurdautofirewall" -j ACCEPT
fi
done < ports

#Iterate through firewall rules to make sure no unecessary rules exist for closed murmurd instances
while read rules
do
#If there is a rule corrosponding to murmurd instance confirm in system log
if grep -q "$rules" ports; ##note the space after the string you are searching for
then
echo
#logger Firewall port $rules has murmurd listening
#If a rule exists and there is no murmurd instance close the port and log to system log
else
logger Firewall port $rules was closed
iptables -D INPUT -p tcp --dport $rules -m comment --comment "murmurdautofirewall" -j ACCEPT
iptables -D INPUT -p udp --dport $rules -m comment --comment "murmurdautofirewall" -j ACCEPT
fi
done < rules

#To ensure mimimal logging and activity send process to sleep for 5 mimnutes
sleep 300

done

